import { type NextRequest, NextResponse } from "next/server"
import { neon } from "@neondatabase/serverless"

const sql = neon(process.env.DATABASE_URL!)

export async function DELETE(request: NextRequest, { params }: { params: { id: string } }) {
  try {
    const groupId = Number.parseInt(params.id)

    // Delete songs first (foreign key constraint)
    await sql`DELETE FROM songs WHERE repertoire_group_id = ${groupId}`

    // Delete repertoire group
    const result = await sql`
      DELETE FROM repertoire_groups 
      WHERE id = ${groupId}
      RETURNING id
    `

    if (result.length === 0) {
      return NextResponse.json(
        {
          success: false,
          message: "Grupo não encontrado",
        },
        { status: 404 },
      )
    }

    return NextResponse.json({
      success: true,
      message: "Grupo deletado com sucesso",
    })
  } catch (error) {
    console.error("Delete repertoire error:", error)
    return NextResponse.json(
      {
        success: false,
        message: "Erro interno do servidor",
      },
      { status: 500 },
    )
  }
}
